function eLife_fig3h

%%
xFactor = 1;

%% load the tracks
[file,path] = uigetfile('*.mat','Select the all Tracks file');
cd(path)
load(file);

%% work out the mean
lifetime_s = [allTracks.lifetime_s].';
meanLifetime = mean(lifetime_s,1);

findFrameNoRange = 0:xFactor:meanLifetime+xFactor;
a = abs(meanLifetime - findFrameNoRange(end-1));
b = abs(meanLifetime - findFrameNoRange(end));

if a < b
    meanLifetime = findFrameNoRange(end-1);
elseif b < a
    meanLifetime = findFrameNoRange(end);
end

meanRange = meanLifetime-3:meanLifetime+3;

for i = 1:size(allTracks,2)
    if sum(ismember(meanRange,allTracks(i).lifetime_s)) >= 1
        allTracks(i).toKeep = 1;
    else
        allTracks(i).toKeep = 0;
    end
end

x = allTracks([allTracks.toKeep] == 1);

for i = 1:size(x,2)
    if numel(x(i).A(1,:)) == x(i).lifetime_s
        x(i).toKeep = 1;
    else
        x(i).toKeep = 0;
    end
end
x = x([x.toKeep] == 1);


rangeMax = max(meanRange);

for i = 1:size(x,2)
    if size(x(i).A(1,:),2) == rangeMax
        Chan1(i,:) = x(i).A(1,:);
        Chan2(i,:) = x(i).A(2,:);
    else
        padSize = rangeMax - x(i).lifetime_s;
        Chan1(i,:) = padarray(x(i).A(1,:),[0 padSize],NaN,'pre');
        Chan2(i,:) = padarray(x(i).A(2,:),[0 padSize],NaN,'pre');
    end
end

for i = 1:size(Chan1,1)
    red = Chan1(i,:);
    Chan1Max = max(red);
    Chan1Min = min(red);
    Chan1Norm(i,:) = (red - Chan1Min) / (Chan1Max-Chan1Min);
    green = Chan2(i,:);
    Chan2Max = max(green);
    Chan2Min = min(green);
    Chan2Norm(i,:) = (green - Chan2Min) / (Chan2Max-Chan2Min);
end

Chan1Mean = nanmean(Chan1Norm);
Chan1SD = nanstd(Chan1Norm);
Chan1SEM = Chan1SD / sqrt(size(Chan1Norm,1));
Chan2Mean = nanmean(Chan2Norm);
Chan2SD = nanstd(Chan2Norm);
Chan2SEM = Chan2SD / sqrt(size(Chan2Norm,1));

%% Plot
timeLine = (-numel(Chan1Mean))+1:1:0;
figure
errorbar(timeLine,Chan1Mean,Chan1SEM,'r')
hold
errorbar(timeLine,Chan2Mean,Chan2SEM,'g')
xlabel({'Time (s)'});
ylabel({'Norm. Fluro (AU).'});
